#include <bits/stdc++.h>
using namespace std;

struct Point
{
    bool operator<(const Point p)
    {
        return (x < p.x) || ((x == p.x) && (y < p.y));
    }
    long long x, y;
};

void print_point_vector(vector<Point> points)
{
    for (long long i = 0; i < points.size(); i++)
    {
        cout << i << ": " << points[i].x << " " << points[i].y << "\n";
    }
    cout << "\n";
}

long long int shoelace(vector<Point> points) {
	long long int leftSum = 0;
	long long int rightSum = 0;

	for (long long i = 0; i < points.size(); ++i) {
		long long j = (i + 1) % points.size();
		leftSum  += points[i].x * points[j].y;
		rightSum += points[j].x * points[i].y;
	}

	return abs(leftSum - rightSum)/2;
}


#define TURN_DIR(p1, p2, p3) (p1.x * p2.y - p1.y * p2.x + \
                              p2.x * p3.y - p2.y * p3.x + \
                              p3.x * p1.y - p3.y * p1.x)
#define LAST(cntnr) (cntnr).back()
#define BEFORE_LAST(cntnr) (cntnr)[(cntnr).size() - 2]

void ConvexHull(vector<Point> &pts)
{
    sort(pts.begin(), pts.end());

    vector<Point> lower, upper;
    for (unsigned i = 0; i < pts.size(); ++i)
    {
        while (lower.size() > 1 && TURN_DIR(BEFORE_LAST(lower), LAST(lower), pts[i]) <= 0)
            lower.pop_back();
        while (upper.size() > 1 && TURN_DIR(BEFORE_LAST(upper), LAST(upper), pts[i]) >= 0)
            upper.pop_back();

        lower.push_back(pts[i]);
        upper.push_back(pts[i]);
    }

    upper.insert(upper.end(), lower.rbegin() + 1, lower.rend() - 1);
    pts.swap(upper);
}

int main()
{
    long long n;
    cin >> n;

    vector<Point> points(n);

    for (long long i = 0; i < n; i++)
    {
        cin >> points[i].x >> points[i].y;
    }
    cout<<"\npoints vector:\n";
    print_point_vector(points);
    vector<long long int> areas(n);

    for (long long i = 0; i < n; i++)
    {
        vector<Point> points_without_dead_point = points;

        points_without_dead_point.erase(points_without_dead_point.begin() + i);
        cout<<"\ndead point vector:\n";
        print_point_vector(points_without_dead_point);
        ConvexHull(points_without_dead_point);
        cout<<"\nconvex hull vector:\n";
        print_point_vector(points_without_dead_point);
        areas[i]=shoelace(points_without_dead_point);
        cout<<"\ncurrent area: "<<areas[i]<<"\n";
    }

    sort(areas.begin(), areas.end());

    long long unsigned int t = static_cast<long long unsigned int>((areas[0]));
    cout<<t;
    return 0;
}